// Copyright (c) 2016-2017, XMOS Ltd, All rights reserved
#include <stdlib.h>
#include <stdio.h>
#include <xclib.h>
#include "spi.h"

char image[] = {
#include "image.h"
};

out port              p_ss[1] = {XS1_PORT_1E}; // X0D12
out buffered port:32  p_sclk  = XS1_PORT_1F;   // X0D13
out buffered port:32  p_mosi  = XS1_PORT_1G;   // X0D22
clock                 cb      = XS1_CLKBLK_1;

#define SPEED_KHZ 1000
#define DEASSERT_TIME_TICKS 1000

void spi_master_app(client interface spi_master_if i)
{
  int j;
  printf("%d bytes to send\n", sizeof(image));
  i.begin_transaction(0, SPEED_KHZ, SPI_MODE_1); // actually mode 0 (or 3)
  for (j = 0; j < sizeof(image); j++) {
    i.transfer8(bitrev(image[j]) >> 24); // bit reverse so we get LSb first on the bus
  }
  i.end_transaction(DEASSERT_TIME_TICKS);
  printf("done\n");
  exit(0);
}

int main(void)
{
  interface spi_master_if i[1];
  par {
    spi_master_app(i[0]);
    spi_master(i, 1, p_sclk, p_mosi, null, p_ss, 1, cb);
  }
  return 0;
}
