// Copyright (c) 2016-2017, XMOS Ltd, All rights reserved
#include <xs1.h>

// XS1_RAM_BASE + XS1_RAM_SIZE
// - 4 * ((XS1_DBG_BUFFER_WORDS + 1 + _cmdline_buffer_stackwords) $A 2)
#define STACK_256B 0x7FB

// tools 14.3 introduced the .crt section, which comes before .text in
// default ordering; our loader then needs to be in .crt as well,
// otherwise it would be placed after CRT code (even with --first)
#if XCC_VERSION_MAJOR > 1402 // decimal
#error "Only for xTIMEcomposer 14.2 or older"
#endif

.section .text, "ax", @progbits
.globl pll_ctl
.globl ref_clk_divider
.globl routing_table
.align 4
bu _pre_crt
.align 4            // word align trampoline
image_sizes:
.word 0             // image sizes to be patched in by image generation script
.word 0
pll_ctl:
.word 0             // read from XN file by image generation script and patched in
ref_clk_divider:
.word 0
routing_table:
.word 0
.word 0
_pre_crt:
ldc r11, STACK_256B // allocate some stack space so we can call an XC function
shl r11, r11, 8     // CRT will setup stack again properly
set sp, r11
ldap r11, _cp       // also initialise CP so XC can load constants
set cp, r11
ldap r11, image_sizes
getr r4, XS1_RES_TYPE_CHANEND
mov r0, r4          // use a callee save register for freeing the resource later
ldw r1, r11[0]
ldw r2, r11[1]
ldw r3, r11[2]
bl boot_tile1
freer res[r4]
bl _start           // go to _start, normally the symbol at start of RAM
