// Copyright (c) 2015, XMOS Ltd, All rights reserved

#define DEBUG_MEMORY_LOG_ENABLED 1
#ifdef DEBUG_MEMORY_LOG_ENABLED

#include <stdlib.h>

unsigned int debug_memory_log_buffer_index = 0;
#define DEBUG_MEMORY_LOG_BUFFER_SIZE 2048
unsigned char debug_memory_log_buffer[DEBUG_MEMORY_LOG_BUFFER_SIZE];

// Override the weak symbol used for print messages
int _write(int fd, const unsigned char *data, size_t len) {

  // Check for wrap of the circular buffer
  if ((debug_memory_log_buffer_index + len + 1) > DEBUG_MEMORY_LOG_BUFFER_SIZE) 
    debug_memory_log_buffer_index = 0;

  // Copy write message into log buffer
  for(unsigned int i = 0; i < len; i++) {
    debug_memory_log_buffer[debug_memory_log_buffer_index] = data[i];
    debug_memory_log_buffer_index++;
  }

  // Terminate the whole buffer after the current message
  debug_memory_log_buffer[debug_memory_log_buffer_index] = '\0';
 
  return len;
}

#endif
