// Copyright (c) 2015, XMOS Ltd, All rights reserved
#include "usb.h"
#include "i2c.h"
#include "hid_mouse_extended.h"

/* Prototype for Endpoint0 function in endpoint0.xc */
void Endpoint0(chanend c_ep0_out, chanend c_ep0_in);

/* Global report buffer, global since used by Endpoint0 core */
unsigned char g_reportBuffer[4] = {0, 0, 0, 0};

#define XUD_EP_COUNT_OUT   1
#define XUD_EP_COUNT_IN    2

// I2C interface ports
on tile[0]: port p_scl = XS1_PORT_1E;
on tile[0]: port p_sda = XS1_PORT_1F;

/* 
 * The main function runs three cores on tile[1] : the XUD manager, Endpoint 0, and a HID endpoint. 
 * An array of * channels is used for both IN and OUT endpoints, endpoint zero requires both, HID requires 
 * just an IN endpoint to send HID reports to the host. On tile[0] the interface to the I2C device
 * uses another core.
 */
int main()
{
    i2c_master_if i2c[1];
    chan c_ep_out[XUD_EP_COUNT_OUT], c_ep_in[XUD_EP_COUNT_IN];

    par
    {
      on tile[1]: xud(c_ep_out, XUD_EP_COUNT_OUT, c_ep_in, XUD_EP_COUNT_IN,
                      null, XUD_SPEED_HS, XUD_PWR_SELF);

      on tile[1]: Endpoint0(c_ep_out[0], c_ep_in[0]);

      on tile[1]: hid_mouse_extended(c_ep_in[1], i2c[0]);

      on tile[0]: i2c_master(i2c, 1, p_scl, p_sda, 10);
    }

    return 0;
}
