// Copyright (c) 2015, XMOS Ltd, All rights reserved
#include "usb.h"
#include "u_series_adc.h"
#include "hid_mouse_extended.h"

/* Prototype for Endpoint0 function in endpoint0.xc */
void Endpoint0(chanend c_ep0_out, chanend c_ep0_in);

/* Global report buffer, global since used by Endpoint0 core */
unsigned char g_reportBuffer[4] = {0, 0, 0, 0};

#define XUD_EP_COUNT_OUT   1
#define XUD_EP_COUNT_IN    2

/* The main function runs three cores: the XUD manager, Endpoint 0, and a HID endpoint. An array of
 * channels is used for both IN and OUT endpoints, endpoint zero requires both, HID requires just an
 * IN endpoint to send HID reports to the host.
 */
int main()
{
    chan c_ep_out[XUD_EP_COUNT_OUT], c_ep_in[XUD_EP_COUNT_IN];
    chan c_adc;

    par
    {
      on tile[0]: xud(c_ep_out, XUD_EP_COUNT_OUT, c_ep_in, XUD_EP_COUNT_IN,
                      null, XUD_SPEED_HS, XUD_PWR_SELF);

      on tile[0]: Endpoint0(c_ep_out[0], c_ep_in[0]);

      on tile[0]: hid_mouse_extended(c_ep_in[1], c_adc);

      xs1_su_adc_service(c_adc);
    }

    return 0;
}

