// Copyright (c) 2015, XMOS Ltd, All rights reserved

#include <xs1.h>
#include <xclib.h>
#include <platform.h>

//Ports to interface with ADC
on tile[0] : clock clk = XS1_CLKBLK_1;
on tile[0] : in port p_clk_in = XS1_PORT_1E;
on tile[0] : out buffered port:32 p_clk_out = XS1_PORT_1A;
on tile[0] : out buffered port:32 p_rd = XS1_PORT_1B;
on tile[0] : out buffered port:32 p_convsr = XS1_PORT_1C;
on tile[0] : out buffered port:32 p_sdi = XS1_PORT_1D;
on tile[0] : out port p_cs = XS1_PORT_1F;
on tile[0] : in buffered port:32 p_sdoa = XS1_PORT_1G;
on tile[0] : in buffered port:32 p_sdob = XS1_PORT_1H;
on tile[0] : in port p_busy = XS1_PORT_1I;

//For Slave emulation
on tile[0] : out buffered port:32 p_dummy_1 = XS1_PORT_1J;
on tile[0] : out buffered port:32 p_dummy_2 = XS1_PORT_1K;
on tile[0] : in port p_signal = XS1_PORT_1L;
on tile[0] : in buffered port:32 p_clk_in_sim = XS1_PORT_1M;
on tile[0] : clock clk_1 = XS1_CLKBLK_2;

void master_ads7863a( streaming chanend c)
{
  unsigned data_1,data_2,ts;
  //reference clock is set to 50MHz
  configure_clock_rate(clk,100,2); 
  configure_port_clock_output(p_clk_out, clk);
  //Configuring all the ports synchronous to reference clock
  configure_out_port(p_convsr, clk, 0);
  configure_out_port(p_sdi, clk, 0);
  configure_out_port(p_rd, clk, 0);
  configure_in_port(p_sdoa, clk);
  configure_in_port(p_sdob, clk);

  p_rd<:0x0000000;
  p_convsr<:0x00000000;
  p_sdi<:0x00000000;
  set_port_shift_count(p_sdoa,16);
  set_port_shift_count(p_sdoa,16);
  start_clock(clk);
  p_cs<:0;
  while(1)
  {
      p_rd @ (ts+5)<:0x00010001 ;
      p_convsr @ (ts+5) <:0x00010001;
      //write LSB first for two channels at a time
      p_sdi @ (ts+7) <:0x05555550;
      //Read two channels at a time. As we are usign 32 bit buffered ports
      p_sdoa:> data_1;
      p_sdob:> data_2 @ ts;
      //Send the data read to the application using channels
      c<:data_1;
      c<:data_2;
  }
}

void slave_side_ads7863a_simulation()
{
    unsigned data;
    configure_clock_rate(clk_1,100,2);
    configure_out_port(p_dummy_1, clk_1,0);
    configure_out_port(p_dummy_2, clk_1,0);
    configure_in_port(p_signal, clk_1);
    start_clock(clk_1);

    while(1)
    {
        // wait for conversion start signal from Master
        p_signal:>data ;

        if(data)
        {
            clearbuf(p_dummy_1);
            clearbuf(p_dummy_2);
            //Output Channel A and CHannel B information. Two samples at a time.
            p_dummy_1<: 0x3AAA3AAF ;
            p_dummy_2<: 0xFFFFFFFE;

        }
    }
}

void app( streaming chanend c)
{
    unsigned data;
    while(1)
    {
        //Read Channel A and CHannel B data alternatively.
        c:>data;
    }
}


//main function//
int main()
{
    streaming chan c;
    par
    {
        on tile[0] : master_ads7863a(c);
        on tile[0] : slave_side_ads7863a_simulation();
        on tile[0] : app(c);
    }
}


//End
