// #========================================================================
// #
// #    vectors.S
// #
// #    XMOS startup handling
// #
// #========================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####
// -------------------------------------------
// This file is part of eCos, the Embedded Configurable Operating System.
// Copyright (C) 1998, 1999, 2000, 2001, 2002, 2003, 2009 Free Software Foundation, Inc.
//
// eCos is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 or (at your option) any later
// version.
//
// eCos is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
// for more details.
//
// You should have received a copy of the GNU General Public License
// along with eCos; if not, write to the Free Software Foundation, Inc.,
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
//
// As a special exception, if other files instantiate templates or use
// macros or inline functions from this file, or you compile this file
// and link it with other works to produce a work based on this file,
// this file does not by itself cause the resulting work to be covered by
// the GNU General Public License. However the source code for this file
// must still be made available in accordance with section (3) of the GNU
// General Public License v2.
//
// This exception does not invalidate any other reasons why a work based
// on this file might be covered by the GNU General Public License.
// -------------------------------------------
// ####ECOSGPLCOPYRIGHTEND####
// #========================================================================
// ######DESCRIPTIONBEGIN####
// #
// # Author(s):     XMOS
// # Contributors:  XMOS
// # Date:          2014-02-19
// # Purpose:       exception vectors
// # Description:   This file defines the code placed into the exception
// #                vectors. It also contains the first level default VSRs
// #                that save and restore state for both exceptions and
// #                interrupts.
// #
// #####DESCRIPTIONEND####
// #
// #========================================================================

/*
  README:
  - startup code, exceptions and debug handling are handled using the default
    XMOS start-up sequence; hence no explicit exception handlers and their
    vector support is provided at this point of time

  - interrupt and vector tables are not yet made available as configurable entities:
   initialize any required interrupt support and ISR tables (IVT) - to be explored

  - if required, add macros for kernel support calls (KCALL* related instructions)

  - a need to start the ecos kernel is to be added here (cyg_start); currently,
  cyg_start is added as a part of "hal_hardware_init"

*/

#if 0
#include <pkgconf/hal.h>
#include <pkgconf/hal_arm.h>
#ifdef CYGPKG_KERNEL  // no CDL yet
#include <pkgconf/kernel.h>
#else
# undef CYGFUN_HAL_COMMON_KERNEL_SUPPORT
# undef CYGIMP_HAL_COMMON_INTERRUPTS_USE_INTERRUPT_STACK
#endif
#include <cyg/hal/hal_platform_setup.h>
#endif
//#include <xs1.h>
#include "intr_context.S"

/********************************************************************************
 * Function:     clock_int_                                                     *
 * Parameters:   none                                                           *
 * return:       void                                                           *
 *                                                                              *
 *               Clock interrupt handler.                                       *
 *               1. Saves the context of the current running process.           *
 *               2. Set up the timer for the next interrupt.                    *
 *               3. Increment tick and check for expired delays.                *
 *               4. Check which process to run next.                            *
 *               5. Restore context of the next running process                 *
 ********************************************************************************/
.extern interrupt_end
.extern restore_hal_regs

.extern hal_saved_registers
.extern save_hal_regs

.globl clock_int_.nstackwords
.globl clock_int_.maxthreads
.globl clock_int_.maxtimers
.globl clock_int_.maxchanends
.linkset clock_int_.nstackwords, 0
.linkset clock_int_.maxthreads,  0
.linkset clock_int_.maxtimers,   0
.linkset clock_int_.maxchanends, 0

.globl clock_int_
.text

clock_int_:

    //SAVE_CONTEXT            // save context of current running process
    //bl save_hal_regs
    SAVE_HAL_REGS

    ldc    r5,         1                   //Load a set flag
    stw    r5,         dp[hal_regs_save_flag]   // Set hal_saved_registers_flag
                                           // this will be used while context_switch in interrupt_end branch

    ldw    r1,         dp[tickclock]       // get timer resource
    ldw    r2,         dp[next_int]        // get timer value of current interrupt
    ldw    r3,         cp[timertick]       // save value to add to the time at which the interrupt happened
    add    r2,         r2,             r3  // calculate the time for the next interrupt
    setd   res[r1],    r2                  // set up the timer value for the next interrupt
    stw    r2,         dp[next_int]        // store this value in next_int

    kentsp 512                // switch over to kernel stack pointer, saving the current SP

    bl isr_handler   	    // Attach RTC ISR here from table


    bl interrupt_end

	krestsp 512               // return from kernel stack pointer, restoring saved SP

    //RESTORE_CONTEXT         // restore the context of the next running process

    RESTORE_HAL_REGS

    ldc    r5,         0                   //Reset the above set flag
    stw    r5,         dp[hal_regs_save_flag]   // this was already used while context_switch in interrupt_end branch

    kret                    // handle over the processor to the restored process

/********************************************************************************
 * Function:     init_system_                                                   *
 * Parameters:   none                                                           *
 * return:       void                                                           *
 *                                                                              *
 *               Initialise some low level parts of the system:                 *
 *               1. Set up the timer to generate interrupts.                    *
 *               2. Set up the kernel entry point.                              *
 *               3. Set up the kernel stack pointer.                            *
 ********************************************************************************/
.extern init_system_
.globl init_system_.nstackwords
.globl init_system_.maxthreads
.globl init_system_.maxtimers
.globl init_system_.maxchanends
.linkset init_system_.nstackwords, 0
.linkset init_system_.maxthreads,  0
.linkset init_system_.maxtimers,   0
.linkset init_system_.maxchanends, 0
.globl init_system_

.cc_top init_system_.func, init_system_

init_system_:

    // setup tick timer
    ldap    r11,        clock_int_                   // get address of interrupt handler
    ldw     r1,         dp[tickclock]                // get timer resource handler
    setv    res[r1],    r11                          // set the interrupt vector of the timer
    setc    res[r1],    XS1_SETC_IE_MODE_INTERRUPT   // set timer in interrupt mode
    setc    res[r1],    XS1_SETC_COND_AFTER          // generate interrupt if timer value > timer data register
    in      r0,         res[r1]                      // get current timer value
    ldw     r2,         cp[timertick]                // load timer cycles of one tick to r2
    add     r0,         r0,              r2          // add timer cycles of one tick to current timer value
	setd    res[r1],    r0                           // save the timer value of next interrupt in data register of timer
    stw     r0,         dp[next_int]                 // store this value also in next_int
    eeu     res[r1]                                  // enable events and interrupts from timer

	// set kernel entry point
	ldap    r11,        kep
	set     kep,        r11

    // setup kernel stack
    ldaw    r0,         sp[0]                 // save current SP to r0
    ldaw    r2,         dp[kstack]            // Get address of bottom of stack
    ldc     r3,         256                    // offset from end of stack, must be (KSTACK_SIZE-1)*4
    add     r2,         r3,              r2   // Get top of stack
    set     sp,         r2                    // Set SP to KSP address
    krestsp 0                                 // set KSP
    set     sp,         r0                    // restore SP

    setsr   0x02  // set status register to enable interrupts
                  // If using XGDB and breakpoints before starting the scheduler
                  // enable interrupts at restore_context_ before the kret instruction.
	retsp   0

.cc_bottom init_system_.func

/********************************************************************************
 * KERNEL ENTRY POINT                                                           *
 *                                                                              *
 * Exceptions jump to the kernel entry point (infinite loop)                    *
 * Kernel calls jump to the kernel entry point + 128 bytes.                     *
 * Currently the only kernel call is to manually switch context,                *
 * the argument passed by the KCALL(I) instruction to the exception data        *
 * register is not checked.                                                     *
 ********************************************************************************/
.align 128                   // align the exception section to 128 bytes
kep:                         // entry point for exceptions
    bu kep                   // infinite loop

.align 64                    // kernel must be aligned on 64 bytes
kcall_ep:                    // entry point for kernel calls (switch context)

	SAVE_CONTEXT             // save context of caller process

	ldw r0, sp[1]            // the saved program counter does not contain the next instruction
    ldc r1, 2                // but the address of the KCALL instruction.
    add r0, r0, r1           // Add two to the saved program counter that was saved on the stack
	stw r0, sp[1]            // to jump over the KCALL instruction.

    kentsp 128               // switch to kernel stack pointer

	bl isr_handler           // choose which process to run next

    krestsp 128              // return from kernel stack pointer and restore saved SP

	RESTORE_CONTEXT          // restore context of the next running process
	kret                     // handle over the processor to this process

/* END OF KERNEL */

