#include <xs1.h>

#define SAVE_HAL_REGS                                                                                      \
    ldaw   r0,    sp[0];                                                                                   \
    ldaw   r1,    dp[0];    /* save current DP to r1, need to restore DP when leaving function */          \
    ldaw   r2,    dp[hal_saved_registers];                                                                 \
    set    dp,    r2;                                                                                      \
    stw    r2,    dp[2];                                                                                   \
    stw    r3,    dp[3];                                                                                   \
    stw    r4,    dp[4];                                                                                   \
    stw    r5,    dp[5];                                                                                   \
    stw    r6,    dp[6];                                                                                   \
    stw    r7,    dp[7];                                                                                   \
    stw    r8,    dp[8];                                                                                   \
    stw    r9,    dp[9];                                                                                   \
    stw    r10,   dp[10];                                                                                  \
    stw    r11,   dp[11];                                                                                  \
    stw    cp,    dp[12];                                                                                  \
    stw    r1,    dp[13];                                                                                  \
    stw    sp,    dp[14];                                                                                  \
    stw    lr,    dp[15];                                                                                  \
    stw    spc,   sp[1];                                                                                  \
    ldw    r2,    sp[1];                                                                                  \
    stw    r2,    dp[15];                                                                                  \
    set    dp,    r1;    /* restore DP from r1 */                                                          \
    set    sp,    r0;   /* restore SP from r0 */

#define RESTORE_HAL_REGS                                                                                  \
    ldaw    r0,    dp[hal_saved_registers];                                                               \
    set    dp,    r0;                                                                                     \
    ldw    r2,    dp[2];                                                                                  \
    ldw    r3,    dp[3];                                                                                  \
    ldw    r4,    dp[4];                                                                                  \
    ldw    r5,    dp[5];                                                                                  \
    ldw    r6,    dp[6];                                                                                  \
    ldw    r7,    dp[7];                                                                                  \
    ldw    r8,    dp[8];                                                                                  \
    ldw    r9,    dp[9];                                                                                  \
    ldw    r10,   dp[10];                                                                                 \
    ldw    r11,   dp[11];                                                                                 \
    ldw    cp,    dp[12];                                                                                 \
    ldw    lr,    dp[15];                                                                                 \
    ldw    r0,    dp[13];  /* Get DP pointer stored in dp[13] to R0 */                                    \
    ldw    r1,    dp[15]; /* on return from interrupt, KRET sets pc with spc */                           \
    stw    r1,    sp[1];                                                                                  \
    ldw    spc,   sp[1];  /* hence load spc with lr of the new thread to be switched */                   \
    ldw    sp,    dp[14];                                                                                 \
    set    dp,    r0;       /* Get DP from R0 */

/********************************************************************************
 * Macro:        SAVE_CONTEXT                                                   *
 *                                                                              *
 *               Save the context of the current runnig process on              *
 *               the stack of that process. The top word of the stack is        *
 *               not used. Note: it might be possible to use the first          *
 *               stack word (sp[0]) decreasing the context stack frame to       *
 *               19 stack words.                                                *
 ********************************************************************************/

#define SAVE_CONTEXT                                                                                     \
    extsp 20;             /* make room on stack to save context */                                       \
    stw   spc,    sp[1];  /* save the saved program counter register (must be sp[1]!) */                 \
    stw   ssr,    sp[2];  /* save the saved status register (must be sp[2]!) */                          \
    stw   sed,    sp[3];  /* save the saved exception data register (must be sp[3]!) */                  \
    stw   et,     sp[4];  /* save the event type register (must be sp[4]!) */                            \
    stw   dp,     sp[5];  /* save the data pointer */                                                    \
    stw   cp,     sp[6];  /* save the constant pool pointer */                                           \
    stw   lr,     sp[7];  /* save the link register */                                                   \
    stw   r0,     sp[8];  /* save the general purpose registers r0-r11 */                                \
    stw   r1,     sp[9];                                                                                 \
    stw   r2,     sp[10];                                                                                \
    stw   r3,     sp[11];                                                                                \
    stw   r4,     sp[12];                                                                                \
    stw   r5,     sp[13];                                                                                \
    stw   r6,     sp[14];                                                                                \
    stw   r7,     sp[15];                                                                                \
    stw   r8,     sp[16];                                                                                \
    stw   r9,     sp[17];                                                                                \
    stw   r10,    sp[18];                                                                                \
    stw   r11,    sp[19];

/********************************************************************************
 * Macro:        RESTORE_CONTEXT                                                *
 *                                                                              *
 *               Restore the process at which pxCurrentTCB points.              *
 *               Only a kret instruction is needed after executing this macro   *
 *               to resume execution of this process.                           *
 ********************************************************************************/
#define RESTORE_CONTEXT                                                                                  \
    ldw   spc,   sp[1];            /* restore saved program counter */                                   \
    ldw   ssr,   sp[2];            /* restore saved status register */                                   \
    ldw   sed,   sp[3];            /* restore saved exception data */                                    \
    ldw   et,    sp[4];            /* restore exception type */                                          \
    ldw   dp,    sp[5];            /* restore data pointer */                                            \
    ldw   cp,    sp[6];            /* restore constant pool pointer */                                   \
    ldw   r0,    sp[8];            /* restore GP registers r0-r9 */                                      \
    ldw   r1,    sp[9];                                                                                  \
    ldw   r2,    sp[10];                                                                                 \
    ldw   r3,    sp[11];                                                                                 \
    ldw   r4,    sp[12];                                                                                 \
    ldw   r5,    sp[13];                                                                                 \
    ldw   r6,    sp[14];                                                                                 \
    ldw   r7,    sp[15];                                                                                 \
    ldw   r8,    sp[16];                                                                                 \
    ldw   r9,    sp[17];                                                                                 \
    ldw   r10,   sp[18];           /* restore r10 */                                                     \
    ldw   r11,   sp[19];            /* restore r11 */                                                    \
    ldw   lr,    sp[1];            /* load link register with spc (contain pc b4 intr processing) */     \
    setsr 0x02                    /* Set SR to enable interrupts again */
